import { StyleSheet } from "react-native";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
export const reviewStyle = StyleSheet.create({
    titleCont: {
        flexDirection: "column",
        alignItems: "center",
    },
    reviewCount: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(56),
        color: "#2C2C2C",
        marginTop: dpr(30),
        marginBottom: dpr(5),
    },
    reviewAverage: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#8C8C8C",
        marginTop: dpr(10),
    },
    reviewBarCont: {
        marginTop: dpr(30),
    },
    reviewProgressCont: {
        flexDirection: "row",
        alignItems: "center",
        marginBottom: dpr(10),
    },
    ratingText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
        marginRight: dpr(15),
    },
    progressBar: {
        width: dpr("wf") - (dpr(20) * 2 + dpr(35)),
        height: 6.5,
        borderRadius: 5,
        backgroundColor: "#E5E5E5",
    },
    progress: (progress) => ({
        height: 6.5,
        borderRadius: 5,
        backgroundColor: "#FCCA19",
        width: `${progress}%`
    }),
    CGCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        marginTop: dpr(25),
    },
    CGText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
    },
    singleReviewWrap: {
        paddingBottom: dpr(20),
    },
    writeReviewCont: {
        backgroundColor: "#ffffff",
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 12,
        },
        shadowOpacity: 0.6,
        elevation: 24,
    },
    writeReview: {
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        paddingVertical: dpr(24),
    },
    writeText: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginLeft: dpr(10),
    },
});
